/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment;

import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.assignment.TrafficAssignmentBuilder;
import org.goplanit.assignment.ltm.sltm.StaticLtmTrafficAssignmentBuilder;
import org.goplanit.assignment.traditionalstatic.TraditionalStaticAssignmentBuilder;
import org.goplanit.demands.Demands;
import org.goplanit.input.InputBuilderListener;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.zoning.Zoning;

public class TrafficAssignmentBuilderFactory {
    public static TrafficAssignmentBuilder<?> createBuilder(String trafficAssignmentType, IdGroupingToken projectToken, InputBuilderListener inputBuilder, Demands theDemands, Zoning theZoning, LayeredNetwork<?, ?> theNetwork) throws PlanItException {
        if (trafficAssignmentType.equals(TrafficAssignment.TRADITIONAL_STATIC_ASSIGNMENT)) {
            return new TraditionalStaticAssignmentBuilder(projectToken, inputBuilder, theDemands, theZoning, theNetwork);
        }
        if (trafficAssignmentType.equals(TrafficAssignment.SLTM)) {
            return new StaticLtmTrafficAssignmentBuilder(projectToken, inputBuilder, theDemands, theZoning, theNetwork);
        }
        throw new PlanItException(String.format("Unable to construct builder for given trafficAssignmentType %s", trafficAssignmentType));
    }
}

