/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment;

import java.util.logging.Logger;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.assignment.TrafficAssignmentConfigurator;
import org.goplanit.component.PlanitComponentBuilder;
import org.goplanit.component.PlanitComponentFactory;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.demands.Demands;
import org.goplanit.gap.GapFunction;
import org.goplanit.gap.StopCriterion;
import org.goplanit.input.InputBuilderListener;
import org.goplanit.interactor.InteractorAccessor;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.output.OutputManager;
import org.goplanit.output.enums.OutputType;
import org.goplanit.sdinteraction.smoothing.Smoothing;
import org.goplanit.supply.networkloading.NetworkLoading;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.zoning.Zoning;

public abstract class TrafficAssignmentBuilder<T extends TrafficAssignment>
extends PlanitComponentBuilder<T> {
    protected static final Logger LOGGER = Logger.getLogger(TrafficAssignmentBuilder.class.getCanonicalName());
    public static final boolean LOG_SETTINGS = true;

    private void registerDemandZoningAndNetwork(Demands demands, Zoning zoning, LayeredNetwork<?, ?> network) throws PlanItException {
        if (zoning == null || demands == null || network == null) {
            PlanItException.throwIf((zoning == null ? 1 : 0) != 0, (String)"zoning in registerDemandZoningAndNetwork is null", (Object[])new Object[0]);
            PlanItException.throwIf((demands == null ? 1 : 0) != 0, (String)"demands in registerDemandZoningAndNetwork is null", (Object[])new Object[0]);
            PlanItException.throwIf((network == null ? 1 : 0) != 0, (String)"network in registerDemandZoningAndNetwork is null", (Object[])new Object[0]);
        }
        PlanItException.throwIf((!zoning.isCompatibleWithDemands(demands, network.getModes()) ? 1 : 0) != 0, (String)"Zoning structure is incompatible with one or more of the demands, likely the number of zones does not match the number of origins and/or destinations", (Object[])new Object[0]);
        for (Mode mode : network.getModes()) {
            for (TimePeriod timePeriod : demands.timePeriods.asSortedSetByStartTime()) {
                if (demands.get(mode, timePeriod) != null) continue;
                LOGGER.warning("No demand matrix defined for Mode " + mode.getExternalId() + " and Time Period " + timePeriod.getExternalId());
            }
        }
        this.getConfigurator().setInfrastructureNetwork(network);
        this.getConfigurator().setZoning(zoning);
        this.getConfigurator().setDemands(demands);
    }

    private void createOutputManager() {
        this.getConfigurator().setOutputManager(new OutputManager());
    }

    private void initialiseOutputAdapters(T trafficAssignment) {
        this.getConfigurator().getOutputManager().initialiseOutputAdapters((TrafficAssignment)trafficAssignment);
    }

    protected abstract TrafficAssignmentConfigurator<T> createConfigurator() throws PlanItException;

    protected T createTrafficAssignmentInstance() throws PlanItException {
        String trafficAssignmentClassName = this.getClassToBuild().getCanonicalName();
        PlanitComponentFactory assignmentFactory = new PlanitComponentFactory(NetworkLoading.class.getCanonicalName());
        assignmentFactory.addListener(this.getInputBuilderListener());
        Object networkLoadingAndAssignment = assignmentFactory.create(trafficAssignmentClassName, new Object[]{this.groupId});
        PlanItException.throwIf((!(networkLoadingAndAssignment instanceof TrafficAssignment) ? 1 : 0) != 0, (String)"not a valid traffic assignment type", (Object[])new Object[0]);
        return (T)((TrafficAssignment)networkLoadingAndAssignment);
    }

    protected Smoothing createSmoothingInstance() throws PlanItException {
        return (Smoothing)PlanitComponentFactory.createWithListeners(Smoothing.class, this.getConfigurator().getSmoothing().getClassTypeToConfigure(), new Object[]{this.getGroupIdToken()}, this.getInputBuilderListener());
    }

    protected AbstractPhysicalCost createPhysicalCostInstance() throws PlanItException {
        return (AbstractPhysicalCost)PlanitComponentFactory.createWithListeners(AbstractPhysicalCost.class, this.getConfigurator().getPhysicalCost().getClassTypeToConfigure(), new Object[]{this.getGroupIdToken()}, new Object[]{this.getConfigurator().getInfrastructureNetwork()}, this.getInputBuilderListener());
    }

    protected AbstractVirtualCost createVirtualCostInstance() throws PlanItException {
        return (AbstractVirtualCost)PlanitComponentFactory.createWithListeners(AbstractVirtualCost.class, this.getConfigurator().getVirtualCost().getClassTypeToConfigure(), new Object[]{this.getGroupIdToken()}, this.getInputBuilderListener());
    }

    protected GapFunction createGapFunctionInstance(StopCriterion stopCriterion) throws PlanItException {
        return (GapFunction)PlanitComponentFactory.createWithListeners(GapFunction.class, this.getConfigurator().getGapFunction().getClassTypeToConfigure(), new Object[]{this.getGroupIdToken(), stopCriterion}, this.getInputBuilderListener());
    }

    protected void buildSubComponents(T trafficAssignmentInstance) throws PlanItException {
        if (this.getConfigurator().getSmoothing() != null) {
            Smoothing smoothing = this.createSmoothingInstance();
            this.getConfigurator().getSmoothing().configure(smoothing);
            ((TrafficAssignment)trafficAssignmentInstance).setSmoothing(smoothing);
        }
        if (this.getConfigurator().getPhysicalCost() != null) {
            AbstractPhysicalCost physicalCost = this.createPhysicalCostInstance();
            this.getConfigurator().getPhysicalCost().configure(physicalCost);
            ((TrafficAssignment)trafficAssignmentInstance).setPhysicalCost(physicalCost);
            if (physicalCost instanceof InteractorAccessor) {
                ((InteractorAccessor)((Object)physicalCost)).setAccessee((Object)trafficAssignmentInstance);
            }
        }
        if (this.getConfigurator().getVirtualCost() != null) {
            AbstractVirtualCost virtualCost = this.createVirtualCostInstance();
            this.getConfigurator().getVirtualCost().configure(virtualCost);
            ((TrafficAssignment)trafficAssignmentInstance).setVirtualCost(virtualCost);
            if (virtualCost instanceof InteractorAccessor) {
                ((InteractorAccessor)((Object)virtualCost)).setAccessee((Object)trafficAssignmentInstance);
            }
        }
        if (this.getConfigurator().getGapFunction() != null) {
            StopCriterion stopCriterion = new StopCriterion();
            this.getConfigurator().getGapFunction().getStopCriterion().configure(stopCriterion);
            GapFunction gapFunction = this.createGapFunctionInstance(stopCriterion);
            this.getConfigurator().getGapFunction().configure(gapFunction);
            ((TrafficAssignment)trafficAssignmentInstance).setGapFunction(gapFunction);
        }
    }

    protected TrafficAssignmentBuilder(Class<T> trafficAssignmentClass, IdGroupingToken projectToken, InputBuilderListener inputBuilderListener, Demands demands, Zoning zoning, LayeredNetwork<?, ?> network) throws PlanItException {
        super(trafficAssignmentClass, projectToken, inputBuilderListener);
        this.registerDemandZoningAndNetwork(demands, zoning, network);
        this.createOutputManager();
        this.getConfigurator().activateOutput(OutputType.LINK);
    }

    public TrafficAssignmentConfigurator<T> getConfigurator() {
        return (TrafficAssignmentConfigurator)super.getConfigurator();
    }

    public T build() throws PlanItException {
        T trafficAssignment = this.createTrafficAssignmentInstance();
        this.getConfigurator().configure(trafficAssignment);
        ((TrafficAssignment)trafficAssignment).verifyNetworkDemandZoningCompatibility();
        this.buildSubComponents(trafficAssignment);
        this.initialiseOutputAdapters(trafficAssignment);
        if (this.getConfigurator().isLogSettings()) {
            ((TrafficAssignment)trafficAssignment).logAllSettings();
        }
        return trafficAssignment;
    }
}

