/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.assignment.algorithmb.AlgorithmB;
import org.goplanit.assignment.ltm.eltm.EventBasedLtm;
import org.goplanit.assignment.ltm.sltm.StaticLtm;
import org.goplanit.assignment.traditionalstatic.TraditionalStaticAssignment;
import org.goplanit.component.PlanitComponent;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.physical.initial.InitialModesLinkSegmentCost;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.demands.Demands;
import org.goplanit.gap.GapFunction;
import org.goplanit.interactor.TrafficAssignmentComponentAccessee;
import org.goplanit.network.TopologicalLayerNetwork;
import org.goplanit.network.layer.macroscopic.MacroscopicLinkSegmentImpl;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.output.OutputManager;
import org.goplanit.output.adapter.OutputTypeAdapter;
import org.goplanit.output.enums.OutputType;
import org.goplanit.sdinteraction.smoothing.Smoothing;
import org.goplanit.supply.networkloading.NetworkLoading;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.zoning.Zoning;

public abstract class TrafficAssignment
extends NetworkLoading
implements TrafficAssignmentComponentAccessee {
    private static final long serialVersionUID = 801775330292422910L;
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentImpl.class.getCanonicalName());
    private OutputManager outputManager;
    private TopologicalLayerNetwork<?, ?> physicalNetwork = null;
    private TransportModelNetwork transportNetwork = null;
    private Zoning zoning = null;
    private Demands demands = null;
    private final Map<Class<? extends PlanitComponent<?>>, PlanitComponent<?>> trafficAssignmentComponents;
    protected Map<TimePeriod, InitialModesLinkSegmentCost> initialLinkSegmentCostByTimePeriod;
    protected InitialModesLinkSegmentCost initialLinkSegmentCostTimePeriodAgnostic;
    public static String TRADITIONAL_STATIC_ASSIGNMENT = TraditionalStaticAssignment.class.getCanonicalName();
    public static String ALGORITHM_B = AlgorithmB.class.getCanonicalName();
    public static String ELTM = EventBasedLtm.class.getCanonicalName();
    public static String SLTM = StaticLtm.class.getCanonicalName();

    private void logComponentSettings(PlanitComponent<?> component) {
        Map<String, String> settingsMap = component.collectSettingsAsKeyValueMap();
        if (settingsMap != null) {
            String componentPrefix = LoggingUtils.runIdPrefix((long)this.getId()) + LoggingUtils.surroundwithBrackets((String)component.getClass().getSimpleName());
            settingsMap.forEach((k, v) -> LOGGER.info(componentPrefix + k + " " + v));
        }
    }

    protected String createLoggingPrefix(int iterationIndex) {
        return LoggingUtils.runIdPrefix((long)this.getId()) + LoggingUtils.iterationPrefix((int)iterationIndex);
    }

    protected void checkForEmptyComponents() throws PlanItException {
        PlanItException.throwIf((this.demands == null ? 1 : 0) != 0, (String)"Demand is null", (Object[])new Object[0]);
        PlanItException.throwIf((this.physicalNetwork == null ? 1 : 0) != 0, (String)"Network is null", (Object[])new Object[0]);
        PlanItException.throwIf((this.zoning == null ? 1 : 0) != 0, (String)"Zoning is null", (Object[])new Object[0]);
        PlanItException.throwIf((this.getSmoothing() == null ? 1 : 0) != 0, (String)"Smoothing is null", (Object[])new Object[0]);
        PlanItException.throwIf((this.getGapFunction() == null ? 1 : 0) != 0, (String)"GapFunction is null", (Object[])new Object[0]);
        PlanItException.throwIf((this.getPhysicalCost() == null ? 1 : 0) != 0, (String)"PhysicalCost is null", (Object[])new Object[0]);
        PlanItException.throwIf((this.getVirtualCost() == null ? 1 : 0) != 0, (String)"VirtualCost is null", (Object[])new Object[0]);
    }

    protected abstract void verifyComponentCompatibility() throws PlanItException;

    protected abstract void verifyNetworkDemandZoningCompatibility() throws PlanItException;

    protected void createTransportNetwork() throws PlanItException {
        this.transportNetwork = new TransportModelNetwork(this.physicalNetwork, this.zoning);
        this.transportNetwork.integrateTransportNetworkViaConnectoids();
        if (this.getTransportNetwork().getNumberOfEdgeSegmentsAllLayers() > Integer.MAX_VALUE) {
            throw new PlanItException("currently assignment internals expect to be castable to int, but max value is exceeded for link segments");
        }
        if (this.getTransportNetwork().getNumberOfVerticesAllLayers() > Integer.MAX_VALUE) {
            throw new PlanItException("currently assignment internals expect to be castable to int, but max value is exceeded for vertices");
        }
    }

    protected int getTotalNumberOfNetworkSegments() {
        return this.getTransportNetwork().getNumberOfEdgeSegmentsAllLayers();
    }

    protected int getTotalNumberOfNetworkVertices() {
        return this.getTransportNetwork().getNumberOfVerticesAllLayers();
    }

    protected void disbandTransportNetwork() throws PlanItException {
        this.transportNetwork.removeVirtualNetworkFromPhysicalNetwork();
    }

    protected void initialiseBeforeExecution() throws PlanItException {
        this.checkForEmptyComponents();
        this.createTransportNetwork();
        this.verifyComponentCompatibility();
        this.outputManager.initialiseBeforeSimulation(this.getId());
        this.getPhysicalCost().initialiseBeforeSimulation(this.physicalNetwork);
        this.getVirtualCost().initialiseBeforeSimulation(this.zoning.getVirtualNetwork());
    }

    protected abstract void executeEquilibration() throws PlanItException;

    protected void finalizeAfterExecution() throws PlanItException {
        this.outputManager.finaliseAfterSimulation();
        this.disbandTransportNetwork();
    }

    protected OutputManager getOutputManager() {
        return this.outputManager;
    }

    protected void logRegisteredComponentName(Object item, boolean register) {
        LOGGER.info(LoggingUtils.runIdPrefix((long)this.getId()) + LoggingUtils.logActiveStateByClassName((Object)item, (boolean)register));
    }

    protected void registerComponent(Class<? extends PlanitComponent<?>> componentKey, PlanitComponent<?> component) {
        this.trafficAssignmentComponents.put(componentKey, component);
    }

    public TrafficAssignment(IdGroupingToken groupId) {
        super(groupId);
        this.trafficAssignmentComponents = new HashMap();
        this.initialLinkSegmentCostByTimePeriod = new HashMap<TimePeriod, InitialModesLinkSegmentCost>();
    }

    protected TrafficAssignment(TrafficAssignment other, boolean deepCopy) {
        super(other, deepCopy);
        this.demands = deepCopy ? other.demands.deepClone() : other.demands.shallowClone();
        this.physicalNetwork = deepCopy ? other.physicalNetwork.deepClone() : other.physicalNetwork.shallowClone();
        this.zoning = deepCopy ? other.zoning.deepClone() : other.zoning.shallowClone();
        this.trafficAssignmentComponents = new HashMap();
        other.trafficAssignmentComponents.entrySet().forEach(entry -> this.trafficAssignmentComponents.put((Class)entry.getKey(), deepCopy ? ((PlanitComponent)entry.getValue()).deepClone() : (PlanitComponent)entry.getValue()));
        this.initialLinkSegmentCostTimePeriodAgnostic = other.initialLinkSegmentCostTimePeriodAgnostic.shallowClone();
        this.initialLinkSegmentCostByTimePeriod = new HashMap<TimePeriod, InitialModesLinkSegmentCost>();
        other.initialLinkSegmentCostByTimePeriod.forEach((p, e) -> this.initialLinkSegmentCostByTimePeriod.put((TimePeriod)p, e.shallowClone()));
    }

    public abstract int getIterationIndex();

    public abstract OutputTypeAdapter createOutputTypeAdapter(OutputType var1);

    public void execute() throws PlanItException {
        LOGGER.info(LoggingUtils.runIdPrefix((long)this.getId()) + LoggingUtils.surround((String)this.getClass().getSimpleName(), (char)'-', (int)17));
        this.initialiseBeforeExecution();
        this.executeEquilibration();
        this.finalizeAfterExecution();
        LOGGER.info(LoggingUtils.runIdPrefix((long)this.getId()) + LoggingUtils.surround((String)this.getClass().getSimpleName(), (char)'-', (int)17));
    }

    public void logAllSettings() {
        LOGGER.info(LoggingUtils.runIdPrefix((long)this.getId()) + LoggingUtils.surround((String)"ASSIGNMENT SETTINGS - START", (char)'-', (int)17));
        this.logComponentSettings(this);
        for (Map.Entry<Class<PlanitComponent<?>>, PlanitComponent<?>> componentEntry : this.trafficAssignmentComponents.entrySet()) {
            this.logComponentSettings(componentEntry.getValue());
        }
        LOGGER.info(LoggingUtils.runIdPrefix((long)this.getId()) + LoggingUtils.surround((String)"ASSIGNMENT SETTINGS - END", (char)'-', (int)17));
    }

    @Override
    public void reset() {
        this.initialLinkSegmentCostByTimePeriod.clear();
        this.initialLinkSegmentCostTimePeriodAgnostic = null;
        try {
            this.disbandTransportNetwork();
        }
        catch (PlanItException e) {
            LOGGER.severe(String.format("Unable to reset assignment %s, transport network could not be disbanded", this.getXmlId()));
        }
        this.trafficAssignmentComponents.forEach((clazz, component) -> component.reset());
    }

    public TransportModelNetwork getTransportNetwork() {
        return this.transportNetwork;
    }

    public void setInfrastructureNetwork(TopologicalLayerNetwork<?, ?> physicalNetwork) {
        this.logRegisteredComponentName(physicalNetwork, true);
        this.physicalNetwork = physicalNetwork;
    }

    public TopologicalLayerNetwork<?, ?> getInfrastructureNetwork() {
        return this.physicalNetwork;
    }

    public Demands getDemands() {
        return this.demands;
    }

    public void setDemands(Demands demands) {
        this.logRegisteredComponentName(demands, true);
        this.demands = demands;
    }

    public Zoning getZoning() {
        return this.zoning;
    }

    public void setZoning(Zoning zoning) {
        this.logRegisteredComponentName(zoning, true);
        this.zoning = zoning;
    }

    public void setSmoothing(Smoothing smoothing) {
        this.logRegisteredComponentName(smoothing, true);
        this.registerComponent(Smoothing.class, smoothing);
    }

    public Smoothing getSmoothing() {
        return this.getTrafficAssignmentComponent(Smoothing.class);
    }

    public void setGapFunction(GapFunction gapfunction) {
        this.logRegisteredComponentName(gapfunction, true);
        this.registerComponent(GapFunction.class, gapfunction);
    }

    public GapFunction getGapFunction() {
        return this.getTrafficAssignmentComponent(GapFunction.class);
    }

    public void setInitialLinkSegmentCost(InitialModesLinkSegmentCost initialLinkSegmentCost) {
        this.initialLinkSegmentCostTimePeriodAgnostic = initialLinkSegmentCost;
    }

    public void setInitialLinkSegmentCost(TimePeriod timePeriod, InitialModesLinkSegmentCost initialLinkSegmentCost) {
        this.initialLinkSegmentCostByTimePeriod.put(timePeriod, initialLinkSegmentCost);
    }

    public <LS extends MacroscopicLinkSegment> void setPhysicalCost(AbstractPhysicalCost physicalCost) {
        this.logRegisteredComponentName(physicalCost, true);
        this.registerComponent(AbstractPhysicalCost.class, physicalCost);
    }

    public AbstractPhysicalCost getPhysicalCost() {
        return this.getTrafficAssignmentComponent(AbstractPhysicalCost.class);
    }

    public AbstractVirtualCost getVirtualCost() {
        return this.getTrafficAssignmentComponent(AbstractVirtualCost.class);
    }

    public void setVirtualCost(AbstractVirtualCost virtualCost) throws PlanItException {
        this.logRegisteredComponentName(virtualCost, true);
        this.registerComponent(AbstractVirtualCost.class, virtualCost);
    }

    @Override
    public <T> T getTrafficAssignmentComponent(Class<T> planitComponentClass) {
        PlanitComponent<?> component = this.trafficAssignmentComponents.get(planitComponentClass);
        if (component == null) {
            LOGGER.warning(String.format("Unable to access component supposed to be registered under %s, consider registering it first", planitComponentClass.getName()));
        }
        return (T)component;
    }

    public void setOutputManager(OutputManager outputManager) {
        this.outputManager = outputManager;
        outputManager.getOutputFormatters().forEach(of -> this.logRegisteredComponentName(of, true));
        outputManager.getRegisteredOutputTypeConfigurations().forEach(oc -> LOGGER.info(LoggingUtils.runIdPrefix((long)this.getId()) + "activated: OutputType." + oc.getOutputType()));
    }

    @Override
    public abstract TrafficAssignment shallowClone();

    @Override
    public abstract TrafficAssignment deepClone();
}

