/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.shortest;

import java.util.function.Function;
import org.goplanit.algorithms.shortest.ShortestPathSearchUtils;
import org.goplanit.algorithms.shortest.ShortestResult;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.misc.Pair;

public abstract class ShortestResultGeneralised
implements ShortestResult {
    protected final double[] vertexMeasuredCost;
    protected final ShortestSearchType searchType;
    protected Function<EdgeSegment, DirectedVertex> getVertexAtExtreme;

    protected Pair<DirectedVertex, DirectedVertex> getStartEndVertexForResultTraversal(DirectedVertex origin, DirectedVertex destination) {
        if (this.isInverted()) {
            return Pair.of((Object)origin, (Object)destination);
        }
        return Pair.of((Object)destination, (Object)origin);
    }

    protected ShortestResultGeneralised(double[] vertexMeasuredCost, ShortestSearchType searchType) {
        this.vertexMeasuredCost = vertexMeasuredCost;
        this.searchType = searchType;
        this.getVertexAtExtreme = ShortestPathSearchUtils.getVertexFromEdgeSegmentLambda(searchType, true);
    }

    @Override
    public DirectedVertex getNextVertexForEdgeSegment(EdgeSegment edgeSegment) {
        return this.getVertexAtExtreme.apply(edgeSegment);
    }

    @Override
    public ShortestSearchType getSearchType() {
        return this.searchType;
    }
}

