/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.shortest;

import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.assignment.ltm.sltm.RootedLabelledBush;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;

public final class ShortestPathSearchUtils {
    private static final Logger LOGGER = Logger.getLogger(ShortestPathSearchUtils.class.getCanonicalName());

    public static Function<EdgeSegment, DirectedVertex> getVertexFromEdgeSegmentLambda(ShortestSearchType shortestPathSearchType) {
        return ShortestPathSearchUtils.getVertexFromEdgeSegmentLambda(shortestPathSearchType, false);
    }

    public static Function<EdgeSegment, DirectedVertex> getVertexFromEdgeSegmentLambda(RootedLabelledBush bush, boolean invertDirection) {
        if (bush.isInverted()) {
            return ShortestPathSearchUtils.getVertexFromEdgeSegmentLambda(ShortestSearchType.ALL_TO_ONE, invertDirection);
        }
        return ShortestPathSearchUtils.getVertexFromEdgeSegmentLambda(ShortestSearchType.ONE_TO_ALL, invertDirection);
    }

    public static Function<EdgeSegment, DirectedVertex> getVertexFromEdgeSegmentLambda(RootedLabelledBush bush) {
        return ShortestPathSearchUtils.getVertexFromEdgeSegmentLambda(bush, false);
    }

    public static Function<EdgeSegment, DirectedVertex> getVertexFromEdgeSegmentLambda(ShortestSearchType shortestPathSearchType, boolean invertDirection) {
        switch (shortestPathSearchType) {
            case ONE_TO_ALL: 
            case ONE_TO_ONE: {
                return EdgeSegment.getVertexForEdgeSegmentLambda((boolean)invertDirection);
            }
            case ALL_TO_ONE: {
                return EdgeSegment.getVertexForEdgeSegmentLambda((!invertDirection ? 1 : 0) != 0);
            }
        }
        LOGGER.severe(String.format("Shortest path search type %s not supported by getVertexFromEdgeSegmentLambda", shortestPathSearchType.toString()));
        return null;
    }

    public static Function<DirectedVertex, Iterable<? extends EdgeSegment>> getEdgeSegmentsInDirectionLambda(RootedLabelledBush bush, boolean invertDirection) {
        if (bush.isInverted()) {
            return ShortestPathSearchUtils.getEdgeSegmentsInDirectionLambda(ShortestSearchType.ALL_TO_ONE, invertDirection);
        }
        return ShortestPathSearchUtils.getEdgeSegmentsInDirectionLambda(ShortestSearchType.ONE_TO_ALL, invertDirection);
    }

    public static Function<DirectedVertex, Iterable<? extends EdgeSegment>> getEdgeSegmentsInDirectionLambda(RootedLabelledBush bush) {
        return ShortestPathSearchUtils.getEdgeSegmentsInDirectionLambda(bush, false);
    }

    public static Function<DirectedVertex, Iterable<? extends EdgeSegment>> getEdgeSegmentsInDirectionLambda(ShortestSearchType shortestPathSearchType) {
        return ShortestPathSearchUtils.getEdgeSegmentsInDirectionLambda(shortestPathSearchType, false);
    }

    public static Function<DirectedVertex, Iterable<? extends EdgeSegment>> getEdgeSegmentsInDirectionLambda(ShortestSearchType shortestPathSearchType, boolean invertDirection) {
        switch (shortestPathSearchType) {
            case ONE_TO_ALL: 
            case ONE_TO_ONE: {
                return DirectedVertex.getEdgeSegmentsForVertexLambda((boolean)invertDirection);
            }
            case ALL_TO_ONE: {
                return DirectedVertex.getEdgeSegmentsForVertexLambda((!invertDirection ? 1 : 0) != 0);
            }
        }
        LOGGER.severe(String.format("Shortest path search type %s not supported by getEdgeSegmentsInDirectionLambda", shortestPathSearchType.toString()));
        return null;
    }
}

