/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.shortest;

import java.util.LinkedList;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.ShortestPathResult;
import org.goplanit.algorithms.shortest.ShortestResultGeneralised;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.path.DirectedPathFactory;
import org.goplanit.utils.path.SimpleDirectedPath;

public class ShortestPathResultGeneralised
extends ShortestResultGeneralised
implements ShortestPathResult {
    private static final Logger LOGGER = Logger.getLogger(ShortestPathResultGeneralised.class.getCanonicalName());
    protected final EdgeSegment[] nextEdgeSegmentByVertex;

    protected ShortestPathResultGeneralised(double[] vertexMeasuredCost, EdgeSegment[] nextEdgeSegmentByVertex, ShortestSearchType searchType) {
        super(vertexMeasuredCost, searchType);
        this.nextEdgeSegmentByVertex = nextEdgeSegmentByVertex;
    }

    @Override
    public <T extends SimpleDirectedPath> T createPath(DirectedPathFactory<T> pathFactory, DirectedVertex origin, DirectedVertex destination) {
        LinkedList<EdgeSegment> pathEdgeSegments = new LinkedList<EdgeSegment>();
        Pair<DirectedVertex, DirectedVertex> startEndPair = this.getStartEndVertexForResultTraversal(origin, destination);
        DirectedVertex startVertex = (DirectedVertex)startEndPair.first();
        DirectedVertex endVertex = (DirectedVertex)startEndPair.second();
        boolean invertedTraversal = this.isInverted();
        int currVertexId = (int)startVertex.getId();
        EdgeSegment nextEdgeSegment = this.nextEdgeSegmentByVertex[currVertexId];
        int endVertexId = (int)endVertex.getId();
        while (endVertexId != currVertexId) {
            if (nextEdgeSegment == null) {
                return null;
            }
            if (invertedTraversal) {
                pathEdgeSegments.add(nextEdgeSegment);
            } else {
                pathEdgeSegments.addFirst(nextEdgeSegment);
            }
            currVertexId = (int)((DirectedVertex)this.getVertexAtExtreme.apply(nextEdgeSegment)).getId();
            nextEdgeSegment = this.nextEdgeSegmentByVertex[currVertexId];
        }
        return (T)pathFactory.createNew(pathEdgeSegments);
    }

    @Override
    public EdgeSegment getNextEdgeSegmentForVertex(Vertex vertex) {
        return this.nextEdgeSegmentByVertex[(int)vertex.getId()];
    }

    @Override
    public double getCostOf(Vertex vertex) {
        return this.vertexMeasuredCost[(int)vertex.getId()];
    }
}

