/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.shortest;

import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import org.goplanit.algorithms.shortest.ShortestPathSearchUtils;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.misc.Pair;

public class ShortestPathGeneralised {
    private static final Comparator<Pair<DirectedVertex, Double>> pairSecondComparator = Comparator.comparing(Pair::second, Comparator.naturalOrder());
    protected DirectedVertex currentSource = null;
    protected final double[] edgeSegmentCosts;
    protected final int numberOfVertices;
    protected Function<EdgeSegment, DirectedVertex> getVertexAtExtreme;
    protected Function<DirectedVertex, Iterable<? extends EdgeSegment>> getEdgeSegmentsInDirection;

    protected Double getEdgeSegmentCost(EdgeSegment edgeSegment) {
        return this.edgeSegmentCosts[(int)edgeSegment.getId()];
    }

    protected void initialiseOpenVertices(PriorityQueue<Pair<DirectedVertex, Double>> openVertices, double[] vertexMeasuredCost) {
        vertexMeasuredCost[(int)this.currentSource.getId()] = 0.0;
        openVertices.add((Pair<DirectedVertex, Double>)Pair.of((Object)this.currentSource, (Object)0.0));
    }

    protected double[] internalExecute(BiPredicate<Double, Double> verifyVertex, Consumer<EdgeSegment> shortestAlternativeEdgeSegmentConsumer) {
        boolean[] vertexVisited = new boolean[this.numberOfVertices];
        double[] vertexMeasuredCost = new double[this.numberOfVertices];
        Arrays.fill(vertexMeasuredCost, Double.MAX_VALUE);
        Object[] nextEdgeSegmentByVertex = new EdgeSegment[this.numberOfVertices];
        Arrays.fill(nextEdgeSegmentByVertex, null);
        PriorityQueue<Pair<DirectedVertex, Double>> openVertices = new PriorityQueue<Pair<DirectedVertex, Double>>(this.numberOfVertices, pairSecondComparator);
        this.initialiseOpenVertices(openVertices, vertexMeasuredCost);
        while (!openVertices.isEmpty()) {
            Pair<DirectedVertex, Double> cheapestNextVertex = openVertices.poll();
            DirectedVertex currentVertex = (DirectedVertex)cheapestNextVertex.first();
            int currentVertexId = (int)currentVertex.getId();
            double currentCost = (Double)cheapestNextVertex.second();
            if (vertexVisited[currentVertexId]) continue;
            vertexVisited[currentVertexId] = true;
            Iterable<? extends EdgeSegment> edgeSegments = this.getEdgeSegmentsInDirection.apply(currentVertex);
            for (EdgeSegment edgeSegment : edgeSegments) {
                DirectedVertex adjacentVertex;
                int adjacentVertexId;
                double currentEdgeSegmentCost = this.getEdgeSegmentCost(edgeSegment);
                if (!(currentEdgeSegmentCost < Double.MAX_VALUE) || vertexVisited[adjacentVertexId = (int)(adjacentVertex = this.getVertexAtExtreme.apply(edgeSegment)).getId()]) continue;
                double adjacentVertexCost = vertexMeasuredCost[adjacentVertexId];
                double computedCostToReachAdjacentVertex = currentCost + currentEdgeSegmentCost;
                if (!verifyVertex.test(adjacentVertexCost, computedCostToReachAdjacentVertex)) continue;
                vertexMeasuredCost[adjacentVertexId] = computedCostToReachAdjacentVertex;
                openVertices.add((Pair<DirectedVertex, Double>)Pair.of((Object)adjacentVertex, (Object)computedCostToReachAdjacentVertex));
                shortestAlternativeEdgeSegmentConsumer.accept(edgeSegment);
            }
        }
        return vertexMeasuredCost;
    }

    protected double[] execute(ShortestSearchType searchType, BiPredicate<Double, Double> verifyVertex, Consumer<EdgeSegment> shortestIncomingEdgeSegmentConsumer) {
        this.getEdgeSegmentsInDirection = ShortestPathSearchUtils.getEdgeSegmentsInDirectionLambda(searchType);
        this.getVertexAtExtreme = ShortestPathSearchUtils.getVertexFromEdgeSegmentLambda(searchType);
        return this.internalExecute(verifyVertex, shortestIncomingEdgeSegmentConsumer);
    }

    protected double[] executeOneToAll(BiPredicate<Double, Double> verifyVertex, Consumer<EdgeSegment> shortestIncomingEdgeSegmentConsumer) {
        return this.execute(ShortestSearchType.ONE_TO_ALL, verifyVertex, shortestIncomingEdgeSegmentConsumer);
    }

    protected double[] executeAllToOne(BiPredicate<Double, Double> verifyVertex, Consumer<EdgeSegment> shortestIncomingEdgeSegmentConsumer) {
        return this.execute(ShortestSearchType.ALL_TO_ONE, verifyVertex, shortestIncomingEdgeSegmentConsumer);
    }

    public ShortestPathGeneralised(double[] edgeSegmentCosts, int numberOfVertices) {
        this.edgeSegmentCosts = edgeSegmentCosts;
        this.numberOfVertices = numberOfVertices;
    }
}

