/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.shortest;

import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.ShortestPathAllToOne;
import org.goplanit.algorithms.shortest.ShortestPathGeneralised;
import org.goplanit.algorithms.shortest.ShortestPathOneToAll;
import org.goplanit.algorithms.shortest.ShortestPathResult;
import org.goplanit.algorithms.shortest.ShortestPathResultGeneralised;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;

public class ShortestPathDijkstra
extends ShortestPathGeneralised
implements ShortestPathOneToAll,
ShortestPathAllToOne {
    private static final Logger LOGGER = Logger.getLogger(ShortestPathDijkstra.class.getCanonicalName());
    protected EdgeSegment[] shortestEdgeSegmentOfVertex;
    protected static final BiPredicate<Double, Double> isShorterPredicate = (currCost, computedCost) -> currCost > computedCost;

    private ShortestPathResult dijkstraExecute(ShortestSearchType searchType, DirectedVertex startVertex, Consumer<EdgeSegment> shortestNextEdgeSegmentConsumer) {
        this.currentSource = startVertex;
        this.shortestEdgeSegmentOfVertex = new EdgeSegment[this.numberOfVertices];
        double[] vertexMeasuredCost = super.execute(searchType, isShorterPredicate, shortestNextEdgeSegmentConsumer);
        return new ShortestPathResultGeneralised(vertexMeasuredCost, this.shortestEdgeSegmentOfVertex, searchType);
    }

    public ShortestPathDijkstra(double[] edgeSegmentCosts, int numberOfVertices) {
        super(edgeSegmentCosts, numberOfVertices);
    }

    public ShortestPathResult execute(ShortestSearchType searchType, DirectedVertex startVertex) {
        switch (searchType) {
            case ONE_TO_ALL: 
            case ONE_TO_ONE: {
                return this.executeOneToAll(startVertex);
            }
            case ALL_TO_ONE: {
                return this.executeAllToOne(startVertex);
            }
        }
        LOGGER.severe("Unsupported search type encountered in Dijkstra shortest path execution");
        return null;
    }

    @Override
    public ShortestPathResult executeOneToAll(DirectedVertex currentOrigin) {
        return this.dijkstraExecute(ShortestSearchType.ONE_TO_ALL, currentOrigin, es -> {
            this.shortestEdgeSegmentOfVertex[(int)es.getDownstreamVertex().getId()] = es;
        });
    }

    @Override
    public ShortestPathResult executeAllToOne(DirectedVertex currentDestination) {
        return this.dijkstraExecute(ShortestSearchType.ALL_TO_ONE, currentDestination, es -> {
            this.shortestEdgeSegmentOfVertex[(int)es.getUpstreamVertex().getId()] = es;
        });
    }
}

