/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.shortest;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.goplanit.algorithms.shortest.MinMaxPathResult;
import org.goplanit.algorithms.shortest.MinMaxPathResultImpl;
import org.goplanit.algorithms.shortest.ShortestPathAllToOne;
import org.goplanit.algorithms.shortest.ShortestPathOneToAll;
import org.goplanit.algorithms.shortest.ShortestPathSearchUtils;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.graph.directed.acyclic.ACyclicSubGraph;

public class ShortestPathAcyclicMinMaxGeneralised
implements ShortestPathOneToAll,
ShortestPathAllToOne {
    private final Collection<? extends DirectedVertex> topologicalOrder;
    private final ACyclicSubGraph acyclicSubGraph;
    private final double[] edgeSegmentCosts;
    private final int numParentNetworkVertices;
    protected Function<EdgeSegment, DirectedVertex> getVertexAtExtreme;
    protected Function<DirectedVertex, Iterable<? extends EdgeSegment>> getEdgeSegmentsInDirection;

    public ShortestPathAcyclicMinMaxGeneralised(ACyclicSubGraph acyclicSubGraph, boolean updateTopologicalOrder, double[] edgeSegmentCosts, int parentNetworkVertices) {
        this.acyclicSubGraph = acyclicSubGraph;
        this.topologicalOrder = this.acyclicSubGraph.topologicalSort(updateTopologicalOrder);
        this.edgeSegmentCosts = edgeSegmentCosts;
        this.numParentNetworkVertices = parentNetworkVertices;
    }

    public MinMaxPathResultImpl execute(DirectedVertex startVertex) {
        double[] minCost = new double[this.numParentNetworkVertices];
        double[] maxCost = new double[this.numParentNetworkVertices];
        Arrays.fill(minCost, Double.POSITIVE_INFINITY);
        Arrays.fill(maxCost, Double.NEGATIVE_INFINITY);
        EdgeSegment[] minCostNextEdgeSegments = new EdgeSegment[this.numParentNetworkVertices];
        EdgeSegment[] maxCostNextEdgeSegments = new EdgeSegment[this.numParentNetworkVertices];
        minCost[(int)startVertex.getId()] = 0.0;
        maxCost[(int)startVertex.getId()] = 0.0;
        for (DirectedVertex directedVertex : this.topologicalOrder) {
            int vertexIndex = (int)directedVertex.getId();
            Iterable<? extends EdgeSegment> edgeSegments = this.getEdgeSegmentsInDirection.apply(directedVertex);
            for (EdgeSegment edgeSegment : edgeSegments) {
                int nextVertexIndex;
                if (!this.acyclicSubGraph.containsEdgeSegment(edgeSegment)) continue;
                double edgeCost = this.edgeSegmentCosts[(int)edgeSegment.getId()];
                double foundCostToNextVertex = minCost[vertexIndex] + edgeCost;
                if (foundCostToNextVertex < minCost[nextVertexIndex = (int)this.getVertexAtExtreme.apply(edgeSegment).getId()]) {
                    minCost[nextVertexIndex] = foundCostToNextVertex;
                    minCostNextEdgeSegments[nextVertexIndex] = edgeSegment;
                }
                if (!((foundCostToNextVertex = maxCost[vertexIndex] + edgeCost) >= maxCost[nextVertexIndex])) continue;
                maxCost[nextVertexIndex] = foundCostToNextVertex;
                maxCostNextEdgeSegments[nextVertexIndex] = edgeSegment;
            }
        }
        return new MinMaxPathResultImpl(minCost, minCostNextEdgeSegments, maxCost, maxCostNextEdgeSegments);
    }

    @Override
    public MinMaxPathResult executeAllToOne(DirectedVertex currentDestination) {
        this.getEdgeSegmentsInDirection = ShortestPathSearchUtils.getEdgeSegmentsInDirectionLambda(ShortestSearchType.ALL_TO_ONE);
        this.getVertexAtExtreme = ShortestPathSearchUtils.getVertexFromEdgeSegmentLambda(ShortestSearchType.ALL_TO_ONE);
        return this.execute(currentDestination);
    }

    @Override
    public MinMaxPathResult executeOneToAll(DirectedVertex currentOrigin) {
        this.getEdgeSegmentsInDirection = ShortestPathSearchUtils.getEdgeSegmentsInDirectionLambda(ShortestSearchType.ONE_TO_ALL);
        this.getVertexAtExtreme = ShortestPathSearchUtils.getVertexFromEdgeSegmentLambda(ShortestSearchType.ONE_TO_ALL);
        return this.execute(currentOrigin);
    }
}

