/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.shortest;

import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Set;
import org.goplanit.algorithms.shortest.ShortestPathOneToOne;
import org.goplanit.algorithms.shortest.ShortestPathResult;
import org.goplanit.algorithms.shortest.ShortestPathResultGeneralised;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.misc.Pair;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShortestPathAStar
implements ShortestPathOneToOne {
    protected final double[] edgeSegmentCosts;
    protected final int numberOfEdgeSegments;
    protected final int numberOfVertices;
    protected final PlanitJtsCrsUtils geoUtils;
    protected final double heuristicDistanceMultiplier;
    protected static final Comparator<Pair<DirectedVertex, Double>> pairSecondComparator = Comparator.comparing(Pair::second, Comparator.naturalOrder());

    public ShortestPathAStar(double[] edgeSegmentCosts, int numberOfVertices, CoordinateReferenceSystem crs, double heuristicDistanceMultiplier) {
        this.edgeSegmentCosts = edgeSegmentCosts;
        this.numberOfVertices = numberOfVertices;
        this.numberOfEdgeSegments = edgeSegmentCosts.length;
        this.geoUtils = new PlanitJtsCrsUtils(crs);
        this.heuristicDistanceMultiplier = heuristicDistanceMultiplier;
    }

    @Override
    public ShortestPathResult executeOneToOne(DirectedVertex origin, DirectedVertex destination, Set<? extends EdgeSegment> bannedSegments) {
        Pair<DirectedVertex, Double> cheapestNextVertex;
        int vertexId;
        if (origin.getPosition() == null || destination.getPosition() == null) {
            throw new PlanItRunTimeException("aStar shortest path must compute distances between vertices on-the-fly. One or more vertices do not have location information available making this impossible");
        }
        double[] vertexMeasuredCost = new double[this.numberOfVertices];
        Arrays.fill(vertexMeasuredCost, Double.POSITIVE_INFINITY);
        double[] vertexHeuristicCost = new double[this.numberOfVertices];
        Arrays.fill(vertexHeuristicCost, Double.POSITIVE_INFINITY);
        EdgeSegment[] incomingEdgeSegment = new EdgeSegment[this.numberOfVertices];
        boolean[] closedVertex = new boolean[this.numberOfVertices];
        Arrays.fill(closedVertex, Boolean.FALSE);
        PriorityQueue<Pair<DirectedVertex, Double>> openVertices = new PriorityQueue<Pair<DirectedVertex, Double>>(this.numberOfVertices, pairSecondComparator);
        openVertices.add((Pair<DirectedVertex, Double>)Pair.of((Object)origin, (Object)0.0));
        vertexMeasuredCost[(int)origin.getId()] = 0.0;
        vertexHeuristicCost[(int)origin.getId()] = this.geoUtils.getDistanceInKilometres(origin.getPosition(), destination.getPosition()) * this.heuristicDistanceMultiplier;
        incomingEdgeSegment[(int)origin.getId()] = null;
        DirectedVertex currentVertex = null;
        while (!openVertices.isEmpty() && (long)(vertexId = (int)(currentVertex = (DirectedVertex)(cheapestNextVertex = openVertices.poll()).first()).getId()) != destination.getId()) {
            if (closedVertex[vertexId]) continue;
            closedVertex[vertexId] = true;
            double costToVertex = vertexMeasuredCost[vertexId];
            for (EdgeSegment adjacentEdgeSegment : currentVertex.getExitEdgeSegments()) {
                if (bannedSegments != null && !bannedSegments.isEmpty() && bannedSegments.contains(adjacentEdgeSegment)) continue;
                int adjacentVertexId = (int)adjacentEdgeSegment.getDownstreamVertex().getId();
                double exitEdgeCost = this.edgeSegmentCosts[(int)adjacentEdgeSegment.getId()];
                if (!(exitEdgeCost < Double.MAX_VALUE)) continue;
                double tentativeCost = costToVertex + exitEdgeCost;
                DirectedVertex adjacentVertex = adjacentEdgeSegment.getDownstreamVertex();
                double adjacentMeasuredCost = vertexMeasuredCost[adjacentVertexId];
                if (adjacentMeasuredCost == Double.POSITIVE_INFINITY) {
                    vertexHeuristicCost[adjacentVertexId] = this.geoUtils.getDistanceInKilometres(adjacentVertex.getPosition(), destination.getPosition()) * this.heuristicDistanceMultiplier;
                }
                if (!(adjacentMeasuredCost > tentativeCost)) continue;
                incomingEdgeSegment[adjacentVertexId] = adjacentEdgeSegment;
                vertexMeasuredCost[adjacentVertexId] = tentativeCost;
                double priorityCost = tentativeCost + vertexHeuristicCost[adjacentVertexId];
                openVertices.add((Pair<DirectedVertex, Double>)Pair.of((Object)adjacentVertex, (Object)priorityCost));
            }
        }
        if (currentVertex.getId() != destination.getId()) {
            throw new PlanItRunTimeException("Destination %s (id:%d) unreachable from origin %S (id:%d)", new Object[]{destination.getXmlId(), destination.getId(), origin.getXmlId(), origin.getId()});
        }
        return new ShortestPathResultGeneralised(vertexMeasuredCost, incomingEdgeSegment, ShortestSearchType.ONE_TO_ONE);
    }

    @Override
    public ShortestPathResult executeOneToOne(DirectedVertex origin, DirectedVertex destination) {
        return this.executeOneToOne(origin, destination, null);
    }
}

