/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.shortest;

import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortest.ShortestBushResult;
import org.goplanit.algorithms.shortest.ShortestResultGeneralised;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.graph.directed.acyclic.ACyclicSubGraphImpl;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.graph.directed.acyclic.ACyclicSubGraph;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.CollectionUtils;
import org.goplanit.utils.misc.Pair;

public class ShortestBushResultGeneralised
extends ShortestResultGeneralised
implements ShortestBushResult {
    private static final Logger LOGGER = Logger.getLogger(ShortestBushResultGeneralised.class.getCanonicalName());
    protected final Object[] nextEdgeSegments;
    protected final int numberOfEdgeSegments;

    protected ShortestBushResultGeneralised(double[] vertexMeasuredCost, Object[] nextEdgeSegmentsByVertex, int numberOfEdgeSegments, ShortestSearchType searchType) {
        super(vertexMeasuredCost, searchType);
        this.nextEdgeSegments = nextEdgeSegmentsByVertex;
        this.numberOfEdgeSegments = numberOfEdgeSegments;
    }

    @Override
    public ACyclicSubGraph createDirectedAcyclicSubGraph(IdGroupingToken idToken, DirectedVertex origin, DirectedVertex destination) {
        Pair<DirectedVertex, DirectedVertex> startEndPair = this.getStartEndVertexForResultTraversal(origin, destination);
        DirectedVertex startSearchVertex = (DirectedVertex)startEndPair.first();
        DirectedVertex endSearchVertex = (DirectedVertex)startEndPair.second();
        ACyclicSubGraphImpl dag = new ACyclicSubGraphImpl(idToken, endSearchVertex, this.isInverted(), this.numberOfEdgeSegments);
        TreeSet<DirectedVertex> openVertices = new TreeSet<DirectedVertex>();
        HashSet<Vertex> processedVertices = new HashSet<Vertex>();
        openVertices.add(startSearchVertex);
        while (!openVertices.isEmpty()) {
            Vertex currVertex = (Vertex)openVertices.first();
            openVertices.remove(currVertex);
            List<EdgeSegment> eligibleNextEdgeSegments = this.getNextEdgeSegmentsForVertex(currVertex);
            if (!CollectionUtils.nullOrEmpty(eligibleNextEdgeSegments)) {
                for (EdgeSegment edgeSegment : eligibleNextEdgeSegments) {
                    dag.addEdgeSegment(edgeSegment);
                    DirectedVertex nextVertex = (DirectedVertex)this.getVertexAtExtreme.apply(edgeSegment);
                    if (processedVertices.contains(nextVertex)) continue;
                    openVertices.add(nextVertex);
                }
            }
            processedVertices.add(currVertex);
        }
        return dag;
    }

    @Override
    public List<EdgeSegment> getNextEdgeSegmentsForVertex(Vertex vertex) {
        Object incomingEdgeSegmentsAtVertex = this.nextEdgeSegments[(int)vertex.getId()];
        if (incomingEdgeSegmentsAtVertex instanceof EdgeSegment) {
            return List.of((EdgeSegment)incomingEdgeSegmentsAtVertex);
        }
        return (List)incomingEdgeSegmentsAtVertex;
    }

    @Override
    public double getCostOf(Vertex vertex) {
        return this.vertexMeasuredCost[(int)vertex.getId()];
    }
}

