/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.shortest;

import java.util.ArrayList;
import java.util.List;
import org.goplanit.algorithms.shortest.ShortestBushAllToOne;
import org.goplanit.algorithms.shortest.ShortestBushOneToAll;
import org.goplanit.algorithms.shortest.ShortestBushResult;
import org.goplanit.algorithms.shortest.ShortestBushResultGeneralised;
import org.goplanit.algorithms.shortest.ShortestPathGeneralised;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.math.Precision;

public class ShortestBushGeneralised
extends ShortestPathGeneralised
implements ShortestBushOneToAll,
ShortestBushAllToOne {
    protected Object[] nextEdgeSegments;
    protected boolean currEqualShortestCosts;

    private boolean isShorterOrEqual(double currShortestCostToVertex, double currComputedCostToVertex) {
        this.currEqualShortestCosts = false;
        if (Precision.smaller((double)currShortestCostToVertex, (double)currComputedCostToVertex)) {
            return false;
        }
        if (Precision.equal((double)currShortestCostToVertex, (double)currComputedCostToVertex, (double)1.0E-15)) {
            this.currEqualShortestCosts = true;
        }
        return true;
    }

    private void processShorterOrEqualIncomingEdgeSegment(EdgeSegment addNextEdgeSegment) {
        DirectedVertex nextSegmentVertex = (DirectedVertex)this.getVertexAtExtreme.apply(addNextEdgeSegment);
        int nextSegmentRefVertexId = (int)nextSegmentVertex.getId();
        if (this.currEqualShortestCosts) {
            Object currentEligibleEdgeSegmentsVertex = this.nextEdgeSegments[nextSegmentRefVertexId];
            if (currentEligibleEdgeSegmentsVertex instanceof EdgeSegment) {
                ArrayList<EdgeSegment> list = new ArrayList<EdgeSegment>(2);
                list.add((EdgeSegment)currentEligibleEdgeSegmentsVertex);
                list.add(addNextEdgeSegment);
                this.nextEdgeSegments[nextSegmentRefVertexId] = list;
            } else {
                ((List)this.nextEdgeSegments[nextSegmentRefVertexId]).add(addNextEdgeSegment);
            }
        } else {
            this.nextEdgeSegments[nextSegmentRefVertexId] = addNextEdgeSegment;
        }
    }

    public ShortestBushGeneralised(double[] edgeSegmentCosts, int numberOfVertices) {
        super(edgeSegmentCosts, numberOfVertices);
    }

    @Override
    public ShortestBushResult executeOneToAll(DirectedVertex currentOrigin) {
        this.currentSource = currentOrigin;
        this.nextEdgeSegments = new Object[this.numberOfVertices];
        double[] vertexMeasuredCost = super.executeOneToAll(this::isShorterOrEqual, this::processShorterOrEqualIncomingEdgeSegment);
        return new ShortestBushResultGeneralised(vertexMeasuredCost, this.nextEdgeSegments, this.edgeSegmentCosts.length, ShortestSearchType.ONE_TO_ALL);
    }

    @Override
    public ShortestBushResult executeAllToOne(DirectedVertex currentDestination) {
        this.currentSource = currentDestination;
        this.nextEdgeSegments = new Object[this.numberOfVertices];
        double[] vertexMeasuredCost = super.executeAllToOne(this::isShorterOrEqual, this::processShorterOrEqualIncomingEdgeSegment);
        return new ShortestBushResultGeneralised(vertexMeasuredCost, this.nextEdgeSegments, this.edgeSegmentCosts.length, ShortestSearchType.ALL_TO_ONE);
    }
}

