/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.shortest;

import org.goplanit.algorithms.shortest.MinMaxPathResult;
import org.goplanit.algorithms.shortest.ShortestPathResultGeneralised;
import org.goplanit.algorithms.shortest.ShortestSearchType;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.path.DirectedPathFactory;
import org.goplanit.utils.path.SimpleDirectedPath;

public class MinMaxPathResultImpl
implements MinMaxPathResult {
    private boolean minPathState = true;
    private ShortestPathResultGeneralised minPathResult;
    private ShortestPathResultGeneralised maxPathResult;

    protected MinMaxPathResultImpl(double[] minVertexCost, EdgeSegment[] minCostBackwardEdgeSegments, double[] maxVertexCost, EdgeSegment[] maxCostBackwardEdgeSegments) {
        this.minPathResult = new ShortestPathResultGeneralised(minVertexCost, minCostBackwardEdgeSegments, ShortestSearchType.ONE_TO_ALL);
        this.maxPathResult = new ShortestPathResultGeneralised(maxVertexCost, maxCostBackwardEdgeSegments, ShortestSearchType.ONE_TO_ALL);
    }

    @Override
    public void setMinPathState(boolean flag) {
        this.minPathState = flag;
    }

    @Override
    public <T extends SimpleDirectedPath> T createPath(DirectedPathFactory<T> pathFactory, DirectedVertex origin, DirectedVertex destination) {
        return this.minPathState ? this.minPathResult.createPath(pathFactory, origin, destination) : this.maxPathResult.createPath(pathFactory, origin, destination);
    }

    @Override
    public EdgeSegment getNextEdgeSegmentForVertex(Vertex vertex) {
        return this.minPathState ? this.minPathResult.getNextEdgeSegmentForVertex(vertex) : this.maxPathResult.getNextEdgeSegmentForVertex(vertex);
    }

    @Override
    public DirectedVertex getNextVertexForEdgeSegment(EdgeSegment edgeSegment) {
        return this.minPathState ? this.minPathResult.getNextVertexForEdgeSegment(edgeSegment) : this.maxPathResult.getNextVertexForEdgeSegment(edgeSegment);
    }

    @Override
    public double getCostOf(Vertex vertex) {
        return this.minPathState ? this.minPathResult.getCostOf(vertex) : this.maxPathResult.getCostOf(vertex);
    }

    @Override
    public ShortestSearchType getSearchType() {
        return this.minPathResult.searchType;
    }
}

