/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.nodemodel;

import org.goplanit.algorithms.nodemodel.TampereNodeModelFixedInput;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.math.Precision;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.function.aggregator.Aggregator;

public class TampereNodeModelInput {
    protected final TampereNodeModelFixedInput fixedInput;
    protected Array2D<Double> turnSendingFlows;
    protected Array1D<Double> outgoingLinkSegmentReceivingFlows;
    protected Array1D<Double> capacityScalingFactors;

    private void verifyInputs(TampereNodeModelFixedInput fixedInput, Array2D<Double> turnSendingFlows) throws PlanItException {
        PlanItException.throwIf((fixedInput == null ? 1 : 0) != 0, (String)"network mapping is null", (Object[])new Object[0]);
        PlanItException.throwIf((turnSendingFlows == null ? 1 : 0) != 0, (String)"turn sending flows are null", (Object[])new Object[0]);
        PlanItException.throwIf((turnSendingFlows.countRows() != (long)fixedInput.getNumberOfIncomingLinkSegments() || turnSendingFlows.countColumns() != (long)fixedInput.getNumberOfOutgoingLinkSegments() ? 1 : 0) != 0, (String)"Number of rows and/or columns in turn sending flows do not match the number of incoming and/or outgoing links in the node model mapping", (Object[])new Object[0]);
    }

    private void computeInLinkSegmentCapacityScalingFactors() {
        this.capacityScalingFactors = Array1D.PRIMITIVE64.makeZero((long)this.fixedInput.getNumberOfIncomingLinkSegments());
        for (int inIndex = 0; inIndex < this.fixedInput.getNumberOfIncomingLinkSegments(); ++inIndex) {
            double inLinkSegmentCapacity = (Double)this.fixedInput.incomingLinkSegmentCapacities.get(inIndex);
            double inLinkSendingFlow = (Double)this.turnSendingFlows.aggregateRow((long)inIndex, Aggregator.SUM);
            double lambdaIncomingLinkScalingFactor = 0.0;
            if (Precision.positive((double)inLinkSendingFlow)) {
                lambdaIncomingLinkScalingFactor = inLinkSegmentCapacity / inLinkSendingFlow;
            }
            this.capacityScalingFactors.set((long)inIndex, lambdaIncomingLinkScalingFactor);
        }
    }

    public TampereNodeModelInput(TampereNodeModelFixedInput fixedInput, Array2D<Double> turnSendingFlows) throws PlanItException {
        this.verifyInputs(fixedInput, turnSendingFlows);
        this.fixedInput = fixedInput;
        this.turnSendingFlows = turnSendingFlows;
        this.outgoingLinkSegmentReceivingFlows = fixedInput.outgoingLinkSegmentReceivingFlows;
        this.computeInLinkSegmentCapacityScalingFactors();
    }

    public TampereNodeModelInput(TampereNodeModelFixedInput fixedInput, Array2D<Double> turnSendingFlows, Array1D<Double> outgoingLinkSegmentReceivingFlows) throws PlanItException {
        this(fixedInput, turnSendingFlows);
        this.outgoingLinkSegmentReceivingFlows = outgoingLinkSegmentReceivingFlows;
    }

    public Array1D<Double> getCapacityScalingFactors() {
        return this.capacityScalingFactors;
    }

    public TampereNodeModelFixedInput getFixedInput() {
        return this.fixedInput;
    }

    public Array2D<Double> getTurnSendingFlows() {
        return this.turnSendingFlows;
    }

    public Array1D<Double> getUsedReceivingFlows() {
        return this.outgoingLinkSegmentReceivingFlows;
    }
}

