/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.nodemodel;

import java.util.ArrayList;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.ojalgo.array.Array1D;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;

public class TampereNodeModelFixedInput {
    protected double maxInLinkSegmentCapacity = DEFAULT_MAX_IN_CAPACITY;
    protected ArrayList<MacroscopicLinkSegment> incomingLinkSegments;
    protected ArrayList<MacroscopicLinkSegment> outgoingLinkSegments;
    protected Array1D<Double> incomingLinkSegmentCapacities;
    protected Array1D<Double> outgoingLinkSegmentReceivingFlows;
    public static double DEFAULT_MAX_IN_CAPACITY = 10000.0;

    private void mapLinkSegments(ArrayList<MacroscopicLinkSegment> linkSegments, Iterable<? extends EdgeSegment> edgeSegments) throws PlanItException {
        PlanItException.throwIf((edgeSegments == null ? 1 : 0) != 0, (String)"edge segments to map are null", (Object[])new Object[0]);
        for (EdgeSegment edgeSegment : edgeSegments) {
            PlanItException.throwIf((!(edgeSegment instanceof MacroscopicLinkSegment) ? 1 : 0) != 0, (String)"Edges of node are not of type MacroScopicLinkSegment when mapping in Tampere node model", (Object[])new Object[0]);
            linkSegments.add((MacroscopicLinkSegment)edgeSegment);
        }
    }

    private void initialiseWithCapacity(Array1D<Double> arrayToInitialise, ArrayList<MacroscopicLinkSegment> linkSegments) throws PlanItException {
        PlanItException.throwIf((linkSegments == null ? 1 : 0) != 0, (String)"link segments to extract capacity from are null", (Object[])new Object[0]);
        arrayToInitialise = Array1D.PRIMITIVE64.makeZero((long)linkSegments.size());
        for (MacroscopicLinkSegment linkSegment : linkSegments) {
            arrayToInitialise.add((Object)Math.min(this.getMaxInLinkSegmentCapacity(), linkSegment.getCapacityOrDefaultPcuH()));
        }
    }

    private void mapIncomingLinkSegments(Iterable<? extends EdgeSegment> incomingEdgeSegments, int numSegments) throws PlanItException {
        this.incomingLinkSegments = new ArrayList(numSegments);
        this.mapLinkSegments(this.incomingLinkSegments, incomingEdgeSegments);
    }

    private void mapOutgoingLinkSegments(Iterable<? extends EdgeSegment> outgoingEdgeSegments, int numSegments) throws PlanItException {
        this.outgoingLinkSegments = new ArrayList(numSegments);
        this.mapLinkSegments(this.outgoingLinkSegments, outgoingEdgeSegments);
    }

    private void initialiseIncomingLinkSegmentCapacities() throws PlanItException {
        this.initialiseWithCapacity(this.incomingLinkSegmentCapacities, this.incomingLinkSegments);
    }

    private void initialiseOutoingLinkSegmentReceivingFlows(boolean initialiseReceivingFlowsAtCapacity) throws PlanItException {
        if (initialiseReceivingFlowsAtCapacity) {
            this.initialiseWithCapacity(this.outgoingLinkSegmentReceivingFlows, this.outgoingLinkSegments);
        } else {
            this.outgoingLinkSegmentReceivingFlows = null;
        }
    }

    public TampereNodeModelFixedInput(Node node, boolean initialiseReceivingFlowsAtCapacity) throws PlanItException {
        this.mapIncomingLinkSegments(node.getEntryEdgeSegments(), node.getNumberOfEntryEdgeSegments());
        this.mapOutgoingLinkSegments(node.getExitEdgeSegments(), node.getNumberOfExitEdgeSegments());
        this.initialiseIncomingLinkSegmentCapacities();
        this.initialiseOutoingLinkSegmentReceivingFlows(initialiseReceivingFlowsAtCapacity);
    }

    public TampereNodeModelFixedInput(Array1D<Double> incomingLinkSegmentCapacities, Array1D<Double> outgoingLinkSegmentReceivingFlows) {
        this.incomingLinkSegmentCapacities = incomingLinkSegmentCapacities.copy();
        this.outgoingLinkSegmentReceivingFlows = outgoingLinkSegmentReceivingFlows.copy();
    }

    public TampereNodeModelFixedInput(Array1D<Double> incomingLinkSegmentCapacities) {
        this.incomingLinkSegmentCapacities = incomingLinkSegmentCapacities.copy();
        this.outgoingLinkSegmentReceivingFlows = null;
    }

    public void capInLinkCapacitiesToMaximum() {
        PrimitiveFunction.Unary capToMaxCapacity = v -> Math.max(this.getMaxInLinkSegmentCapacity(), v);
        this.incomingLinkSegmentCapacities.modifyAll((UnaryFunction)capToMaxCapacity);
    }

    public int getNumberOfIncomingLinkSegments() {
        return this.incomingLinkSegmentCapacities.size();
    }

    public int getNumberOfOutgoingLinkSegments() {
        return this.outgoingLinkSegmentReceivingFlows.size();
    }

    public double getMaxInLinkSegmentCapacity() {
        return this.maxInLinkSegmentCapacity;
    }

    public void setMaxInLinkSegmentCapacity(double maxInLinkSegmentCapacity) {
        this.maxInLinkSegmentCapacity = maxInLinkSegmentCapacity;
    }
}

