/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.nodemodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.goplanit.algorithms.nodemodel.NodeModel;
import org.goplanit.algorithms.nodemodel.TampereNodeModelInput;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.function.NullaryDoubleSupplier;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.Pair;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.Aggregator;

public class TampereNodeModel
implements NodeModel {
    protected final TampereNodeModelInput inputs;
    int numberOfInLinksProcessed;
    protected Array1D<Double> remainingReceivingFlows;
    protected Array2D<Double> scaledRemainingTurnSendingFlows;
    protected boolean[] processedInLinkSegments;
    protected Array1D<Double> incomingLinkSegmentFlowAcceptanceFactors;
    Map<Integer, Integer> mostRestrictingOutLinkIndexByInLinkIndex = new HashMap<Integer, Integer>();

    protected void initialiseRun() throws PlanItException {
        PlanItException.throwIf((this.inputs.outgoingLinkSegmentReceivingFlows == null ? 1 : 0) != 0, (String)"remaining receiving flows not initialised", (Object[])new Object[0]);
        this.numberOfInLinksProcessed = 0;
        this.scaledRemainingTurnSendingFlows = Array2D.PRIMITIVE64.copy(this.inputs.turnSendingFlows);
        this.scaledRemainingTurnSendingFlows.modifyMatchingInColumns(this.inputs.capacityScalingFactors, (BinaryFunction)PrimitiveFunction.MULTIPLY);
        this.remainingReceivingFlows = this.inputs.outgoingLinkSegmentReceivingFlows.copy();
        this.processedInLinkSegments = new boolean[this.inputs.fixedInput.getNumberOfIncomingLinkSegments()];
        this.incomingLinkSegmentFlowAcceptanceFactors = Array1D.PRIMITIVE64.makeFilled((long)this.inputs.fixedInput.getNumberOfIncomingLinkSegments(), (NullaryFunction)NullaryDoubleSupplier.ONE);
    }

    protected Pair<Double, Integer> findMostRestrictingOutLinkSegmentIndex() {
        Integer foundOutLinkSegmentIndex = null;
        double foundRestrictionFactor = Double.POSITIVE_INFINITY;
        int numberOfOutLinkSegments = this.inputs.fixedInput.getNumberOfOutgoingLinkSegments();
        for (int outLinkSegmentIndex = 0; outLinkSegmentIndex < numberOfOutLinkSegments; ++outLinkSegmentIndex) {
            double currentOutgoingRestrictionFactor;
            double remainingReceivingFlow = (Double)this.remainingReceivingFlows.get(outLinkSegmentIndex);
            double sumScaledTurnSendingFlows = (Double)this.scaledRemainingTurnSendingFlows.aggregateColumn((long)outLinkSegmentIndex, Aggregator.SUM);
            if (!Precision.positive((double)sumScaledTurnSendingFlows) || !((currentOutgoingRestrictionFactor = remainingReceivingFlow / sumScaledTurnSendingFlows) < foundRestrictionFactor)) continue;
            foundRestrictionFactor = currentOutgoingRestrictionFactor;
            foundOutLinkSegmentIndex = outLinkSegmentIndex;
        }
        if (foundOutLinkSegmentIndex == null) {
            return null;
        }
        return Pair.of((Object)foundRestrictionFactor, foundOutLinkSegmentIndex);
    }

    protected void updateSets(Pair<Double, Integer> mostRestrictingOutLinkSegmentData) {
        boolean demandConstrainedInLinkFound = this.updateDemandConstrainedInLinkSegments(mostRestrictingOutLinkSegmentData);
        if (!demandConstrainedInLinkFound) {
            this.updateCapacityConstrainedInLinkSegments(mostRestrictingOutLinkSegmentData);
        }
    }

    protected boolean updateDemandConstrainedInLinkSegments(Pair<Double, Integer> mostRestrictingOutLinkSegmentData) {
        ArrayList<Long> demandConstrainedInLinksY = new ArrayList<Long>();
        if (mostRestrictingOutLinkSegmentData == null) {
            for (long index = 0L; index < (long)this.inputs.getFixedInput().getNumberOfIncomingLinkSegments(); ++index) {
                if (this.isInLinkSegmentProcessed((int)index)) continue;
                demandConstrainedInLinksY.add(index);
            }
        } else {
            int mostRestrictedOutLinkIndex = (Integer)mostRestrictingOutLinkSegmentData.second();
            double outLinkSegmentScalingFactorBeta = (Double)mostRestrictingOutLinkSegmentData.first();
            this.scaledRemainingTurnSendingFlows.loopColumn((long)mostRestrictedOutLinkIndex, (inLinkSegmentIndex, outLinkSegmentIndex) -> {
                double requiredScalingFactor;
                double turnSendingFlow = (Double)this.scaledRemainingTurnSendingFlows.get(inLinkSegmentIndex, outLinkSegmentIndex);
                if (Precision.greater((double)turnSendingFlow, (double)1.0E-6) && !this.isInLinkSegmentProcessed((int)inLinkSegmentIndex) && Precision.greaterEqual((double)(requiredScalingFactor = (Double)this.inputs.capacityScalingFactors.get(inLinkSegmentIndex) * outLinkSegmentScalingFactorBeta), (double)1.0)) {
                    demandConstrainedInLinksY.add(inLinkSegmentIndex);
                }
            });
        }
        demandConstrainedInLinksY.forEach(inLinkSegmentIndex -> {
            this.setInLinkSegmentProcessed(inLinkSegmentIndex.intValue());
            ++this.numberOfInLinksProcessed;
            this.updateRemainingReceivingAndSendingFlows((long)inLinkSegmentIndex);
        });
        return !demandConstrainedInLinksY.isEmpty();
    }

    protected void updateCapacityConstrainedInLinkSegments(Pair<Double, Integer> mostRestrictingOutLinkSegmentData) {
        int mostRestrictedOutLinkIndex = (Integer)mostRestrictingOutLinkSegmentData.second();
        double outLinkSegmentScalingFactorBeta = (Double)mostRestrictingOutLinkSegmentData.first();
        this.scaledRemainingTurnSendingFlows.loopColumn((long)mostRestrictedOutLinkIndex, (inLinkSegmentIndex, outLinkSegmentIndex) -> {
            double turnSendingFlow = (Double)this.scaledRemainingTurnSendingFlows.get(inLinkSegmentIndex, outLinkSegmentIndex);
            if (Precision.positive((double)turnSendingFlow, (double)1.0E-6) && !this.isInLinkSegmentProcessed((int)inLinkSegmentIndex)) {
                double flowAcceptanceFactor = (Double)this.inputs.capacityScalingFactors.get(inLinkSegmentIndex) * outLinkSegmentScalingFactorBeta;
                this.updateRemainingReceivingAndSendingFlows(inLinkSegmentIndex, flowAcceptanceFactor);
                this.incomingLinkSegmentFlowAcceptanceFactors.set(inLinkSegmentIndex, flowAcceptanceFactor);
                this.setInLinkSegmentProcessed((int)inLinkSegmentIndex);
                ++this.numberOfInLinksProcessed;
                this.mostRestrictingOutLinkIndexByInLinkIndex.put((int)inLinkSegmentIndex, mostRestrictedOutLinkIndex);
            }
        });
    }

    protected void updateRemainingReceivingAndSendingFlows(long inLinkSegmentIndex) {
        this.updateRemainingReceivingAndSendingFlows(inLinkSegmentIndex, 1.0);
    }

    protected void updateRemainingReceivingAndSendingFlows(long inLinkSegmentIndex, double flowAcceptanceFactor) {
        this.inputs.turnSendingFlows.loopRow(inLinkSegmentIndex, (i, outLinkSegmentIndex2) -> {
            double acceptedTurnSendingflowTo = (Double)this.inputs.turnSendingFlows.get(inLinkSegmentIndex, outLinkSegmentIndex2);
            this.remainingReceivingFlows.modifyOne(outLinkSegmentIndex2, PrimitiveFunction.SUBTRACT.by(acceptedTurnSendingflowTo * flowAcceptanceFactor));
        });
        this.scaledRemainingTurnSendingFlows.fillRow(inLinkSegmentIndex, (Number)0.0);
    }

    protected boolean isInLinkSegmentProcessed(int inLinkSegmentIndex) {
        return this.processedInLinkSegments[inLinkSegmentIndex];
    }

    protected void setInLinkSegmentProcessed(int inLinkSegmentIndex) {
        this.processedInLinkSegments[inLinkSegmentIndex] = true;
    }

    public TampereNodeModel(TampereNodeModelInput tampereNodeModelInput) throws PlanItException {
        PlanItException.throwIf((tampereNodeModelInput == null ? 1 : 0) != 0, (String)"Tampere node model input is null", (Object[])new Object[0]);
        this.inputs = tampereNodeModelInput;
    }

    public Array1D<Double> run() throws PlanItException {
        this.initialiseRun();
        while (this.numberOfInLinksProcessed < this.inputs.fixedInput.getNumberOfIncomingLinkSegments()) {
            Pair<Double, Integer> mostRestrictingOutLinkSegmentData = this.findMostRestrictingOutLinkSegmentIndex();
            boolean demandConstrainedInLinkFound = this.updateDemandConstrainedInLinkSegments(mostRestrictingOutLinkSegmentData);
            if (demandConstrainedInLinkFound) continue;
            this.updateCapacityConstrainedInLinkSegments(mostRestrictingOutLinkSegmentData);
        }
        return this.incomingLinkSegmentFlowAcceptanceFactors;
    }

    public TampereNodeModelInput getInputs() {
        return this.inputs;
    }

    public Map<Integer, Integer> getMostRestrictedOutLinkByInLink() {
        return this.mostRestrictingOutLinkIndexByInLinkIndex;
    }
}

